package assignments.clients.MathService_instance;

import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReferenceType;

import assignments.stubs.MathService_instance.MathPortType;
import assignments.stubs.MathService_instance.GetValueRP;
import assignments.stubs.MathService_instance.service.MathServiceAddressingLocator;

public class Client {

	public static void main(String[] args) {
		MathServiceAddressingLocator locator = new MathServiceAddressingLocator();

		try {
			String serviceURI = args[0];

			// Create endpoint reference to service
			EndpointReferenceType endpoint = new EndpointReferenceType();
			endpoint.setAddress(new Address(serviceURI));
			MathPortType math = locator.getMathPortTypePort(endpoint);

			// Get PortType
			math = locator.getMathPortTypePort(endpoint);

			// Perform an addition
			math.add(10);

			// Perform another addition
			math.add(5);

			// Access value
			System.out.println("Current value: "
					+ math.getValueRP(new GetValueRP()));

			// Perform a subtraction
			math.subtract(5);

			// Access value
			System.out.println("Current value: "
					+ math.getValueRP(new GetValueRP()));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
