package org.globus.examples.clients.MathService_instance;

import java.io.FileInputStream;

import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReferenceType;

import assignments.stubs.MathService_instance.MathPortType;
import assignments.stubs.MathService_instance.GetValueRP;
import assignments.stubs.MathService_instance.service.MathServiceAddressingLocator;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.xml.sax.InputSource;

public class ClientAdd {

	public static void main(String[] args) {
		MathServiceAddressingLocator instanceLocator = new MathServiceAddressingLocator();

		try {
			int value = Integer.parseInt(args[1]);
			EndpointReferenceType instanceEPR;

			if (args[0].startsWith("http")) {
				// First argument contains a URI
				String serviceURI = args[0];
				// Create endpoint reference to service
				instanceEPR = new EndpointReferenceType();
				instanceEPR.setAddress(new Address(serviceURI));
			} else {
				// First argument contains an EPR file name
				String eprFile = args[0];
				// Get endpoint reference of WS-Resource from file
				FileInputStream fis = new FileInputStream(eprFile);
				instanceEPR = (EndpointReferenceType) ObjectDeserializer
						.deserialize(new InputSource(fis),
								EndpointReferenceType.class);
				fis.close();
			}

			// Get PortType
			MathPortType math = instanceLocator
					.getMathPortTypePort(instanceEPR);

			// Perform addition
			math.add(value);

			// Access value
			System.out
					.println("Current value:" + math.getValueRP(new GetValueRP()));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
